/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.client.gui;

import dev.ftb.extendedexchange.config.ConfigHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import net.minecraft.client.gui.screens.Screen;

public class EMCFormat
extends DecimalFormat {
    public static final EMCFormat INSTANCE = new EMCFormat(false);
    public static final EMCFormat INSTANCE_IGNORE_SHIFT = new EMCFormat(true);
    private final boolean ignoreShift;

    private EMCFormat(boolean is) {
        super("#,###");
        this.setRoundingMode(RoundingMode.DOWN);
        this.ignoreShift = is;
    }

    public static String formatBigDecimal(BigDecimal d) {
        Object s = d.toString();
        if (((String)s).length() >= 25) {
            s = ((String)s).substring(0, ((String)s).length() - 24) + "Y";
        } else if (((String)s).length() >= 22) {
            s = ((String)s).substring(0, ((String)s).length() - 21) + "Z";
        } else if (((String)s).length() >= 19) {
            s = ((String)s).substring(0, ((String)s).length() - 18) + "E";
        } else if (((String)s).length() >= 16) {
            s = ((String)s).substring(0, ((String)s).length() - 15) + "P";
        } else if (((String)s).length() >= 13) {
            s = ((String)s).substring(0, ((String)s).length() - 12) + "T";
        } else if (((String)s).length() >= 10) {
            s = ((String)s).substring(0, ((String)s).length() - 9) + "G";
        } else if (((String)s).length() >= 7) {
            s = ((String)s).substring(0, ((String)s).length() - 6) + "M";
        }
        return s;
    }

    @Override
    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        if (((Boolean)ConfigHelper.client().general.overrideEMCFormatter.get()).booleanValue() && number >= 1000000.0 && (this.ignoreShift || !Screen.m_96638_())) {
            int c;
            double num;
            if (number >= 1.0E24) {
                num = number / 1.0E24;
                c = 89;
            } else if (number >= 1.0E21) {
                num = number / 1.0E21;
                c = 90;
            } else if (number >= 1.0E18) {
                num = number / 1.0E18;
                c = 69;
            } else if (number >= 1.0E15) {
                num = number / 1.0E15;
                c = 80;
            } else if (number >= 1.0E12) {
                num = number / 1.0E12;
                c = 84;
            } else if (number >= 1.0E9) {
                num = number / 1.0E9;
                c = 71;
            } else {
                num = number / 1000000.0;
                c = 77;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(String.format("%.02f", num));
            buffer.append((char)c);
            return buffer;
        }
        return super.format(number, result, fieldPosition);
    }

    @Override
    public StringBuffer format(long number, StringBuffer result, FieldPosition fieldPosition) {
        if (((Boolean)ConfigHelper.client().general.overrideEMCFormatter.get()).booleanValue() && number >= 1000000L && (this.ignoreShift || !Screen.m_96638_())) {
            char c;
            double num;
            if (number >= 1000000000000000000L) {
                num = (double)number / 1.0E18;
                c = 'E';
            } else if (number >= 1000000000000000L) {
                num = (double)number / 1.0E15;
                c = 'P';
            } else if (number >= 1000000000000L) {
                num = (double)number / 1.0E12;
                c = 'T';
            } else if (number >= 1000000000L) {
                num = (double)number / 1.0E9;
                c = 'G';
            } else {
                num = (double)number / 1000000.0;
                c = 'M';
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(String.format("%.02f", num));
            buffer.append(c);
            return buffer;
        }
        return super.format(number, result, fieldPosition);
    }
}

